clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default

%% Import data
files = dir('*.mat');
% data = [];
legend_vec = cell(1,length(files));

figure
hold on
for i = 1:length(files)
name_str = files(i).name;
load(name_str)
plot(w_TB_rpm,h_TB)
pos = strfind(name_str,'_');
pos_N = strfind(name_str,'N');
legend_vec{i} = name_str(pos(2)+1:pos_N);

end
grid on
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Minimum film thickness $h$ ($\mu m$)')
title('Spiral Bearing')
legend(legend_vec,'Location','northwest')



